local t = LoadFallbackB()

local theMeasure = LoadModule('Chart.GetNPS.lua')(GAMESTATE:GetCurrentSteps(GAMESTATE:GetMasterPlayerNumber()))

local Bar = Def.ActorFrame{}

for i,density in ipairs(theMeasure[2]) do
	Bar[#Bar+1] = Def.Quad{
		OnCommand=function(self)
			local heckCount = #theMeasure[2]
			local densToPeak = clamp( scale(density, 0, theMeasure[1], 0, 1), 0, 1 )
			
			self:horizalign(left):vertalign(bottom):xy((_screen.w/heckCount)*(i-1),_screen.h-32):zoomto(_screen.w/heckCount,density*2):
				diffuse( lerp_color(densToPeak, LocalGoldColor(0), LocalGoldColor(1)) )
		end
	}
end

t[#t+1] = Bar

t[#t+1] = Def.ActorFrame{
	InitCommand=function(self)
		self:xy(_screen.w*0.25,_screen.cy)
	end,
	
	Def.BitmapText{
		Font = "Common Normal",
		OnCommand=function(self)
			self:y(-110):strokecolor(Color.Black):zoom(0.5)
			self:settext("PEAK NPS: " .. theMeasure[1])
		end
	},
	
	Def.BitmapText{
		Font = "Common Normal",
		OnCommand=function(self)
			self:y(-_screen.cy):vertalign(top):strokecolor(Color.Black):zoom(0.3)
		end
	}
}

return t